<?php
// delete_enquiry.php
require_once 'db_connect.php';
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $status = 0;
    $enquiry_id = $_POST['enquiry_id'] ?? '';
    $agent_id = $_POST['agent_id'] ?? ''; // To ensure agent can only delete their own enquiries
    
    if (empty($enquiry_id) || empty($agent_id)) {
        echo json_encode(['status' => 'error', 'message' => 'Enquiry ID and Agent ID are required.']);
        exit();
    }
    if (!is_numeric($enquiry_id) || !is_numeric($agent_id)) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid ID format.']);
        exit();
    }
    //$stmt = $conn->prepare("DELETE FROM enquiries WHERE id = ? AND agent_id = ?");
    $stmt = $conn->prepare("UPDATE `enquiries` SET `status`= ? WHERE  id = ? AND agent_id = ?");
    $stmt->bind_param("iii",$status, $enquiry_id, $agent_id);
    if ($stmt->execute()) {
        if ($stmt->affected_rows > 0) {
            echo json_encode(['status' => 'success', 'message' => 'Enquiry deleted successfully.']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Enquiry not found or you do not have permission to delete it.']);
        }
    } else {
        error_log("Enquiry deletion failed: " . $stmt->error);
        echo json_encode(['status' => 'error', 'message' => 'Failed to delete enquiry.']);
    }
    $stmt->close();
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
}
$conn->close();
?>