<?php
// register_enquiry.php
require_once 'db_connect.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Use null coalescing operator ?? for safer access
    $agent_id = $_POST['agent_id'] ?? '';
    $parent_name = $_POST['parent_name'] ?? '';
    $mobile_number = $_POST['mobile_number'] ?? '';
    $address = $_POST['address'] ?? '';
    $student_name = $_POST['student_name'] ?? '';
    $class = $_POST['class'] ?? '';
    $hostel_name = $_POST['hostel_name'] ?? '';
    $purpose_of_visit = $_POST['purpose_of_visit'] ?? '';
    $visit_date_time = $_POST['visit_date_time'] ?? ''; // Format: YYYY-MM-DD HH:MM:SS
    $remarks = $_POST['remarks'] ?? null; // Can be null

    // Basic validation
    if (empty($agent_id) || empty($parent_name) || empty($mobile_number) || empty($student_name) || empty($visit_date_time)) {
        echo json_encode(['status' => 'error', 'message' => 'Missing required fields.']);
        exit();
    }

    // Further validation (e.g., mobile number format, date time format)
    if (!is_numeric($agent_id)) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid Agent ID.']);
        exit();
    }
    $mobile_number = preg_replace('/[^0-9]/', '', $mobile_number);
    if (strlen($mobile_number) < 10 || strlen($mobile_number) > 15) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid mobile number format.']);
        exit();
    }
    if (!DateTime::createFromFormat('Y-m-d H:i:s', $visit_date_time)) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid Visit Date & Time format. Use YYYY-MM-DD HH:MM:SS.']);
        exit();
    }

    $stmt = $conn->prepare("INSERT INTO enquiries (agent_id, parent_name, mobile_number, address, student_name, class, hostel_name, purpose_of_visit, visit_date_time, remarks) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("isssssssss", $agent_id, $parent_name, $mobile_number, $address, $student_name, $class, $hostel_name, $purpose_of_visit, $visit_date_time, $remarks);

    if ($stmt->execute()) {
        echo json_encode(['status' => 'success', 'message' => 'Enquiry registered successfully.']);
    } else {
        error_log("Enquiry registration failed: " . $stmt->error); // Log the actual error
        echo json_encode(['status' => 'error', 'message' => 'Failed to register enquiry.']);
    }

    $stmt->close();
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
}

$conn->close();
?>