<?php
// view_enquiries.php
require_once 'db_connect.php';

if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    $agent_id = $_GET['agent_id'] ?? null;
    $search_query = $_GET['search'] ?? '';
    $filter_date = $_GET['date'] ?? ''; // Format: YYYY-MM-DD

    $sql = "SELECT * FROM enquiries WHERE 1=1";
    $params = [];
    $types = "";

    if ($agent_id) {
        $sql .= " AND agent_id = ?";
        $params[] = $agent_id;
        $types .= "i";
    }

    if (!empty($search_query)) {
        $sql .= " AND (parent_name LIKE ? OR student_name LIKE ? OR mobile_number LIKE ?)";
        $search_param = '%' . $search_query . '%';
        $params[] = $search_param;
        $params[] = $search_param;
        $params[] = $search_param;
        $types .= "sss";
    }

    if (!empty($filter_date)) {
        // Validate date format
        if (!DateTime::createFromFormat('Y-m-d', $filter_date)) {
            echo json_encode(['status' => 'error', 'message' => 'Invalid date format. Use YYYY-MM-DD.']);
            exit();
        }
        $sql .= " AND DATE(visit_date_time) = ?";
        $params[] = $filter_date;
        $types .= "s";
    }

    $sql .= " ORDER BY created_at DESC";

    $stmt = $conn->prepare($sql);

    if (!empty($params)) {
        // Use call_user_func_array for binding parameters dynamically
        $stmt->bind_param($types, ...$params);
    }

    $stmt->execute();
    $result = $stmt->get_result();

    $enquiries = [];
    while ($row = $result->fetch_assoc()) {
        $enquiries[] = $row;
    }

    echo json_encode(['status' => 'success', 'data' => $enquiries]);

    $stmt->close();
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
}

$conn->close();
?>