<?php
// admin_login.php - Admin Login Page
session_start();

// If admin is already logged in, redirect to dashboard
if (isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true) {
    header('Location: admin_dashboard.php');
    exit;
}

$pageTitle = 'Admin Login - Hostel Management'; // Set page title
include_once '_header.php'; // Include the external header
?>
    <div class="form-container">
        <div class="form-header">
            <i class="fas fa-user-shield fa-3x text-primary mb-3"></i>
            <h2>Admin Login</h2>
            <p class="text-muted">Access your Hostel Management Dashboard</p>
        </div>
        <form id="adminLoginForm">
            <div class="mb-3">
                <label for="username" class="form-label visually-hidden">Username</label>
                <div class="input-group">
                    <span class="input-group-text rounded-start-pill"><i class="fas fa-user"></i></span>
                    <input type="text" class="form-control rounded-end-pill" id="username" name="username" placeholder="Username" required>
                </div>
            </div>
            <div class="mb-3">
                <label for="password" class="form-label visually-hidden">Password</label>
                <div class="input-group">
                    <span class="input-group-text rounded-start-pill"><i class="fas fa-lock"></i></span>
                    <input type="password" class="form-control rounded-end-pill" id="password" name="password" placeholder="Password" required>
                </div>
            </div>
            <div class="d-grid gap-2 mb-3">
                <button type="submit" class="btn btn-primary">Login</button>
            </div>
            <div class="form-text">
                Don't have an account? <a href="admin_register.php">Register here</a>
            </div>
            <div id="loginMessage" class="alert-message alert d-none" role="alert"></div>
        </form>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const adminLoginForm = document.getElementById('adminLoginForm');
            const loginMessage = document.getElementById('loginMessage');

            adminLoginForm.addEventListener('submit', async function(event) {
                event.preventDefault(); // Prevent default form submission

                // Basic client-side validation
                if (!adminLoginForm.checkValidity()) {
                    event.stopPropagation();
                    adminLoginForm.classList.add('was-validated');
                    return;
                }

                const username = document.getElementById('username').value;
                const password = document.getElementById('password').value;

                loginMessage.className = 'alert-message alert alert-info';
                loginMessage.textContent = 'Attempting to log in...';
                loginMessage.style.display = 'block';

                try {
                    const response = await fetch('login_process.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                        },
                        body: JSON.stringify({ username: username, password: password }),
                    });

                    const data = await response.json();

                    if (data.success) {
                        loginMessage.className = 'alert-message alert alert-success';
                        loginMessage.textContent = data.message || 'Login successful!';
                        setTimeout(() => {
                            window.location.href = data.redirect || 'admin_dashboard.php';
                        }, 1000);
                    } else {
                        loginMessage.className = 'alert-message alert alert-danger';
                        loginMessage.textContent = data.message || 'Login failed. Please check your credentials.';
                    }
                } catch (error) {
                    console.error('Error:', error);
                    loginMessage.className = 'alert-message alert alert-danger';
                    loginMessage.textContent = 'An error occurred during login. Please try again.';
                } finally {
                    loginMessage.style.display = 'block';
                }
            });
        });
    </script>
<?php include_once 'footer.php'; // Include the external footer ?>
