<?php
session_start();
require_once 'db.php';

// Auth check
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php');
    exit;
}

$pageTitle = 'Assignments - Hostel Management';
include_once '_header.php';
include_once '_sidebar.php';
?>

<main class="container-fluid" id="appContent">
    <h1 class="mb-4">Student Assignments</h1>

    <!-- Assignment Form -->
    <div class="card mb-4">
        <div class="card-header">Assign Hostel, Floor, Room, and Bed to Student</div>
        <div class="card-body">
            <form class="row g-3" method="POST" action="assign_student_action.php">
                
                <!-- Class -->
                <div class="col-md-6">
                    <label class="form-label">Select Class</label>
                    <select class="form-select" id="classSelect" required>
                        <option value="">Choose Class...</option>
                        <?php
                        $classes = $conn->query("SELECT DISTINCT class_grade FROM students ORDER BY class_grade ASC");
                        while ($c = $classes->fetch_assoc()) {
                            echo "<option value='".htmlspecialchars($c['class_grade'])."'>".htmlspecialchars($c['class_grade'])."</option>";
                        }
                        ?>
                    </select>
                </div>

                <!-- Student -->
                <div class="col-md-6">
                    <label class="form-label">Select Student</label>
                    <select class="form-select" id="studentSelect" name="unique_reg_number" required>
                        <option value="">Choose Student...</option>
                    </select>
                </div>

                <!-- Hostel -->
                <div class="col-md-6">
                    <label class="form-label">Select Hostel</label>
                    <select class="form-select" id="hostelSelect" name="hostel_id" required>
                        <option value="">Choose Hostel...</option>
                        <?php
                        $hostels = $conn->query("SELECT hostel_id, name FROM hostels WHERE status='active' ORDER BY name ASC");
                        while ($h = $hostels->fetch_assoc()) {
                            echo "<option value='{$h['hostel_id']}'>".htmlspecialchars($h['name'])."</option>";
                        }
                        ?>
                    </select>
                </div>

                <!-- Floor -->
                <div class="col-md-4">
                    <label class="form-label">Select Floor</label>
                    <select class="form-select" id="floorSelect" name="floor_id" required>
                        <option value="">Choose Floor...</option>
                    </select>
                </div>

                <!-- Room -->
                <div class="col-md-4">
                    <label class="form-label">Select Room</label>
                    <select class="form-select" id="roomSelect" name="room_id" required>
                        <option value="">Choose Room...</option>
                    </select>
                </div>

                <!-- Bed -->
                <div class="col-md-4">
                    <label class="form-label">Select Bed</label>
                    <select class="form-select" id="bedSelect" name="bed_id" required>
                        <option value="">Choose Bed...</option>
                    </select>
                </div>

                <div class="col-12 text-end">
                    <button type="submit" class="btn btn-primary"><i class="fas fa-user-plus"></i> Assign Student</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Current Assignments -->
    <div class="card">
        <div class="card-header">Current Assignments</div>
        <div class="card-body table-responsive">
            <table id="assignmentsTable" class="table table-striped table-hover align-middle">
                <thead>
                    <tr>
                        <th>Student Name</th>
                        <th>Reg. No.</th>
                        <th>Hostel</th>
                        <th>Floor</th>
                        <th>Room</th>
                        <th>Bed</th>
                        <th>Assigned Date</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                <?php
                $sql = "SELECT sa.assignment_id, s.full_name, s.unique_reg_number, 
                               h.name AS hostel_name, f.floor_number, r.room_number, b.bed_number, 
                               sa.assigned_date, sa.status
                        FROM student_assignments sa
                        JOIN students s ON sa.unique_reg_number = s.unique_reg_number
                        JOIN beds b ON sa.bed_id = b.bed_id
                        JOIN rooms r ON b.room_id = r.room_id
                        JOIN floors f ON r.floor_id = f.floor_id
                        JOIN hostels h ON f.hostel_id = h.hostel_id
                        ORDER BY sa.assigned_date DESC";
                $res = $conn->query($sql);
                while ($row = $res->fetch_assoc()) {
                    $badge = ($row['status'] == 'assigned') ? 'bg-success' : 'bg-secondary';
                    echo "<tr>
                        <td>".htmlspecialchars($row['full_name'])."</td>
                        <td>{$row['unique_reg_number']}</td>
                        <td>{$row['hostel_name']}</td>
                        <td>{$row['floor_number']}</td>
                        <td>{$row['room_number']}</td>
                        <td>{$row['bed_number']}</td>
                        <td>{$row['assigned_date']}</td>
                        <td><span class='badge $badge rounded-pill'>".ucfirst($row['status'])."</span></td>
                        <td>
                            <a href='view_student_profile.php?reg={$row['unique_reg_number']}' style='width: 75px;' class='btn btn-sm btn-info me-1'>View</a>
                            <a href='vacate_bed.php?id={$row['assignment_id']}' class='btn btn-sm btn-danger mt-2' style='width: 75px;'>Vacate</a>
                        </td>
                    </tr>";
                }
                ?>
                </tbody>
            </table>
        </div>
    </div>
</main>

<!-- SweetAlert2 Notifications -->
<?php if (isset($_SESSION['success']) || isset($_SESSION['error'])): ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
Swal.fire({
    icon: '<?php echo isset($_SESSION['success']) ? 'success' : 'error'; ?>',
    title: '<?php echo isset($_SESSION['success']) ? 'Success' : 'Error'; ?>',
    text: '<?php echo isset($_SESSION['success']) ? $_SESSION['success'] : $_SESSION['error']; ?>',
    timer: 3000,
    showConfirmButton: false
});
</script>
<?php unset($_SESSION['success'], $_SESSION['error']); ?>
<?php endif; ?>

<!-- DataTables JS + CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>

<script>
// Load students when class is selected
$('#classSelect').change(function(){
    var selectedClass = $(this).val();
    $('#studentSelect').html('<option>Loading...</option>');
    if(selectedClass){
        $.get('get_students_by_class.php', {class: selectedClass}, function(data){
            $('#studentSelect').html('<option value="">Choose Student...</option>' + data);
        });
    } else {
        $('#studentSelect').html('<option value="">Choose Student...</option>');
    }
});

// Load floors when hostel selected
$('#hostelSelect').change(function(){
    var hostel_id = $(this).val();
    $('#floorSelect').html('<option>Loading...</option>');
    $.get('get_floors.php', {hostel_id: hostel_id}, function(data){
        $('#floorSelect').html(data);
    });
});

// Load rooms when floor selected
$('#floorSelect').change(function(){
    var floor_id = $(this).val();
    $('#roomSelect').html('<option>Loading...</option>');
    $.get('get_rooms.php', {floor_id: floor_id}, function(data){
        $('#roomSelect').html(data);
    });
});

// Load beds when room selected
$('#roomSelect').change(function(){
    var room_id = $(this).val();
    $('#bedSelect').html('<option>Loading...</option>');
    $.get('get_beds.php', {room_id: room_id}, function(data){
        $('#bedSelect').html(data);
    });
});

// Initialize DataTables
$(document).ready(function() {
    $('#assignmentsTable').DataTable({
        responsive: true,
        dom: 'Bfrtip',
        buttons: [
            'excelHtml5',
            'csvHtml5',
            'pdfHtml5',
            'print'
        ]
    });
});
</script>

<?php include_once 'footer.php'; ?>
