<?php
session_start();
require_once 'db.php';

// Auth check
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['regNo'])) {
    die("Invalid request");
}

$regNo = $_POST['regNo'];

// Fetch old data to retain files if not updated
$stmt = $conn->prepare("SELECT photo_path, aadhar_card_path FROM students WHERE unique_reg_number = ?");
$stmt->bind_param("s", $regNo);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows === 0) {
    die("Student not found");
}
$oldData = $result->fetch_assoc();
$stmt->close();

// Get form data
$fullName = $_POST['fullName'] ?? '';
$classGrade = $_POST['classGrade'] ?? '';
$section = $_POST['section'] ?? '';
$admissionNumber = $_POST['admissionNumber'] ?? '';
$dob = $_POST['dob'] ?? '';
$gender = $_POST['gender'] ?? '';
$fatherName = $_POST['fatherName'] ?? '';
$fatherMobile = $_POST['fatherMobile'] ?? '';
$motherName = $_POST['motherName'] ?? '';
$motherMobile = $_POST['motherMobile'] ?? '';
$permanentAddress = $_POST['permanentAddress'] ?? '';
$correspondenceAddress = $_POST['correspondenceAddress'] ?? '';

// Handle file uploads
$photoPath = $oldData['photo_path'];
$aadharPath = $oldData['aadhar_card_path'];


$uploadDir = __DIR__ . "/uploads/";
// Student photo
if (isset($_FILES['photo']) && $_FILES['photo']['error'] === UPLOAD_ERR_OK) {
    if ($_FILES['photo']['size'] > 2 * 1024 * 1024) {
        die("Photo must be less than 2MB");
    }
    $ext = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);
    
    $photoPathname =  "photo_" . time() . "_" . uniqid() . "." . $ext;
    $photoPath = $uploadDir.$photoPathname;
    move_uploaded_file($_FILES['photo']['tmp_name'], $photoPath);
      $photoDbPath = "uploads/" . $photoPathname;
}

// Aadhaar card
if (isset($_FILES['aadharCard']) && $_FILES['aadharCard']['error'] === UPLOAD_ERR_OK) {
    if ($_FILES['aadharCard']['size'] > 2 * 1024 * 1024) {
        die("Aadhaar card must be less than 2MB");
    }
    $ext = pathinfo($_FILES['aadharCard']['name'], PATHINFO_EXTENSION);
    $aadharPathname = "aadhar_" . time() . "_" . uniqid() . "." . $ext;
    $aadharPath = $uploadDir . $aadharPathname;
    move_uploaded_file($_FILES['aadharCard']['tmp_name'], $aadharPath);
    $aadharDBPath = "uploads/" . $aadharPathname;
}

// Update database
$stmt = $conn->prepare("
    UPDATE students SET 
        full_name = ?, 
        class_grade = ?, 
        section = ?, 
        admission_number = ?, 
        dob = ?, 
        gender = ?, 
        father_name = ?, 
        father_guardian_mobile = ?, 
        mother_name = ?, 
        mother_mobile = ?, 
        permanent_address = ?, 
        correspondence_address = ?, 
        photo_path = ?, 
        aadhar_card_path = ?
    WHERE unique_reg_number = ?
");

$stmt->bind_param(
    "sssssssssssssss",
    $fullName,
    $classGrade,
    $section,
    $admissionNumber,
    $dob,
    $gender,
    $fatherName,
    $fatherMobile,
    $motherName,
    $motherMobile,
    $permanentAddress,
    $correspondenceAddress,
    $photoDbPath,
    $aadharDBPath,
    $regNo
);

if ($stmt->execute()) {
    header("Location: view_student_profile.php?reg=" . urlencode($regNo));
    exit;
} else {
    die("Error updating student: " . $stmt->error);
}

$stmt->close();
$conn->close();
