<?php
require_once 'db.php';

if (!isset($_GET['floor_id']) || empty($_GET['floor_id'])) {
    echo '<option value="">Choose Room...</option>';
    exit;
}

$floor_id = intval($_GET['floor_id']);

$sql = "SELECT room_id, room_number 
        FROM rooms 
        WHERE floor_id = ? 
        ORDER BY room_number ASC";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $floor_id);
$stmt->execute();
$result = $stmt->get_result();

echo '<option value="">Choose Room...</option>';
while ($row = $result->fetch_assoc()) {
    echo '<option value="'.$row['room_id'].'">Room '.$row['room_number'].'</option>';
}

$stmt->close();
$conn->close();
