<?php
// student_registration_step1.php
session_start();

require_once 'db.php';
// Match floors.php auth check
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php');
    exit;
}

$pageTitle = 'Students Registration - Step 1';
require_once 'config.php'; // (must NOT echo anything)
include_once '_header.php';
include_once '_sidebar.php';
?>
<main class="container-fluid" id="appContent">
    <h1 class="mb-4">Student Registration - Step 1</h1>

    <div class="form-header">
        <h2>School Hostel Registration</h2>
        <p class="text-muted">Student Details Form</p>
    </div>

    <!-- Step Indicator -->
    <div class="step-indicator mb-4">
        <div class="step active" id="step1">
            <div class="step-circle">1</div>
            <div class="step-label">Student Info</div>
        </div>
        <div class="step"><div class="step-circle">2</div><div class="step-label">Parent Details</div></div>
        <div class="step"><div class="step-circle">3</div><div class="step-label">Address</div></div>
        <div class="step"><div class="step-circle">4</div><div class="step-label">Emergency Contact</div></div>
        <div class="step"><div class="step-circle">5</div><div class="step-label">Hostel Preferences</div></div>
        <div class="step"><div class="step-circle">6</div><div class="step-label">Documents</div></div>
    </div>

    <!-- Student Information Form (names match action script keys) -->
    <form id="studentRegistrationForm">
        <div class="row g-3 mb-4">
            <div class="col-md-6">
                <label for="fullName" class="form-label">Full Name of Student <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="fullName" name="fullName" required>
            </div>
            <div class="col-md-6">
                <label for="classGrade" class="form-label">Class / Grade <span class="text-danger">*</span></label>
                    <select class="form-select" id="classGrade" name="classGrade" required>
                        <option value="">-- Select Class --</option>
                        <?php
                        $classQuery = $conn->query("SELECT class_name FROM classes ORDER BY class_name ASC");
                        if ($classQuery->num_rows > 0) {
                            while ($row = $classQuery->fetch_assoc()) {
                                echo '<option value="' . htmlspecialchars($row['class_name']) . '">' . htmlspecialchars($row['class_name']) . '</option>';
                            }
                        }
                        ?>
                    </select>
            </div>
            <div class="col-md-6">
                <label for="section" class="form-label">Section (if applicable)</label>
                <input type="text" class="form-control" id="section" name="section">
            </div>
            <div class="col-md-6">
                <label for="admissionNumber" class="form-label">Admission Number / Student ID <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="admissionNumber" name="admissionNumber" required>
            </div>
            <div class="col-md-6">
                <label for="dob" class="form-label">Date of Birth <span class="text-danger">*</span></label>
                <input type="date" class="form-control" id="dob" name="dob" required>
            </div>
            <div class="col-md-6">
                <label for="gender" class="form-label">Gender <span class="text-danger">*</span></label>
                <select class="form-select" id="gender" name="gender" required>
                    <option value="">Select Gender</option>
                    <option value="Male">Male</option>
                    <option value="Female">Female</option>
                    <option value="Other">Other</option>
                </select>
            </div>
            <div class="col-md-6">
                <label for="bloodGroup" class="form-label">Blood Group</label>
                <input type="text" class="form-control" id="bloodGroup" name="bloodGroup" placeholder="e.g., A+, O-">
            </div>
            <div class="col-md-6">
                <label for="religion" class="form-label">Religion</label>
                <input type="text" class="form-control" id="religion" name="religion">
            </div>
            <div class="col-md-6">
                <label for="category" class="form-label">Category <span class="text-danger">*</span></label>
                <select class="form-select" id="category" name="category" required>
                    <option value="">Select Category</option>
                    <option value="General">General</option>
                    <option value="SC">SC</option>
                    <option value="ST">ST</option>
                    <option value="OBC">OBC</option>
                    <option value="Others">Others</option>
                </select>
            </div>
            <div class="col-md-6">
                <label for="aadharNumber" class="form-label">Aadhar Number (if available)</label>
                <input type="text" class="form-control" id="aadharNumber" name="aadharNumber" maxlength="12" pattern="[0-9]{12}" title="Aadhar number must be 12 digits">
            </div>
        </div>

        <div class="d-flex justify-content-end">
            <button type="submit" class="btn btn-primary">Next Step <i class="fas fa-arrow-right ms-2"></i></button>
        </div>
    </form>

    <div id="generatedIdDisplay" class="generated-id-box alert alert-success mt-4" style="display:none;">
        <strong>Registration Successful!</strong>
        <div>Your Unique Registration Number: <span id="uniqueRegNumber" class="fw-bold"></span></div>
    </div>
</main>

<?php include_once 'footer.php'; ?>

<script>
// Robust JSON handling: parse text -> try/catch
document.getElementById('studentRegistrationForm').addEventListener('submit', function (e) {
    e.preventDefault();
    const form = this;
    const formData = new FormData(form);

    fetch('student_registration_step1_action.php', {
        method: 'POST',
        body: formData,
        credentials: 'same-origin'
    })
    .then(res => res.text())
    .then(text => {
        // Debug raw response in console
        console.debug('Raw response:', text);
        let data;
        try { data = JSON.parse(text); } 
        catch (err) {
            alert(data);
            return;
        }

        if (data.status === 'success') {
            document.getElementById('uniqueRegNumber').textContent = data.uniqueId;
            document.getElementById('generatedIdDisplay').style.display = 'block';
            alert(data.unique_id)
            form.reset();
            // OPTIONAL: redirect to step 2 with reg id
             window.location.href = 'student_registration_step2.php?reg=' + encodeURIComponent(data.uniqueId);
        } else {
            alert('Error: ' + (data.message || 'Unknown error'));
        }
    })
    .catch(err => {
        console.error(err);
        alert('Network error. Please try again.');
    });
});
</script>
