<?php
// admin_register.php - Admin Registration Page
session_start();

// If admin is already logged in, redirect to dashboard
if (isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true) {
    header('Location: admin_dashboard.php');
    exit;
}

$pageTitle = 'Admin Registration - Hostel Management'; // Set page title
include_once '_header.php'; // Include the external header
?>
    <div class="form-container">
        <div class="form-header">
            <i class="fas fa-user-plus fa-3x text-primary mb-3"></i>
            <h2>Admin Registration</h2>
            <p class="text-muted">Create your Admin Account</p>
        </div>
        <form id="adminRegisterForm">
            <div class="mb-3">
                <label for="fullName" class="form-label visually-hidden">Full Name</label>
                <div class="input-group">
                    <span class="input-group-text rounded-start-pill"><i class="fas fa-user"></i></span>
                    <input type="text" class="form-control rounded-end-pill" id="fullName" name="fullName" placeholder="Full Name" required>
                </div>
            </div>
            <div class="mb-3">
                <label for="username" class="form-label visually-hidden">Username</label>
                <div class="input-group">
                    <span class="input-group-text rounded-start-pill"><i class="fas fa-user-tag"></i></span>
                    <input type="text" class="form-control rounded-end-pill" id="username" name="username" placeholder="Username" required>
                </div>
            </div>
            <div class="mb-3">
                <label for="email" class="form-label visually-hidden">Email</label>
                <div class="input-group">
                    <span class="input-group-text rounded-start-pill"><i class="fas fa-envelope"></i></span>
                    <input type="email" class="form-control rounded-end-pill" id="email" name="email" placeholder="Email Address" required>
                </div>
            </div>
            <div class="mb-3">
                <label for="password" class="form-label visually-hidden">Password</label>
                <div class="input-group">
                    <span class="input-group-text rounded-start-pill"><i class="fas fa-lock"></i></span>
                    <input type="password" class="form-control rounded-end-pill" id="password" name="password" placeholder="Password" required>
                </div>
            </div>
            <div class="mb-3">
                <label for="confirmPassword" class="form-label visually-hidden">Confirm Password</label>
                <div class="input-group">
                    <span class="input-group-text rounded-start-pill"><i class="fas fa-lock"></i></span>
                    <input type="password" class="form-control rounded-end-pill" id="confirmPassword" name="confirmPassword" placeholder="Confirm Password" required>
                </div>
            </div>

            <!-- User Type Dropdown -->
            <div class="mb-3">
                <div class="input-group">
                    <span class="input-group-text rounded-start-pill"><i class="fas fa-users-cog"></i></span>
                    <select class="form-select rounded-end-pill" id="userType" name="userType" required>
                        <option value="0">Admin</option>
                        <option value="1">Super Admin</option>
                    </select>
                </div>
            </div>

            <div class="d-grid gap-2 mb-3">
                <button type="submit" class="btn btn-primary">Register</button>
            </div>
            <div class="form-text">
                Already have an account? <a href="admin_login.php">Login here</a>
            </div>
            <div id="registerMessage" class="alert-message alert d-none" role="alert"></div>
        </form>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const adminRegisterForm = document.getElementById('adminRegisterForm');
            const registerMessage = document.getElementById('registerMessage');

            adminRegisterForm.addEventListener('submit', async function(event) {
                event.preventDefault(); // Prevent default form submission

                // Basic client-side validation
                if (!adminRegisterForm.checkValidity()) {
                    event.stopPropagation();
                    adminRegisterForm.classList.add('was-validated');
                    return;
                }

                const password = document.getElementById('password').value;
                const confirmPassword = document.getElementById('confirmPassword').value;

                if (password !== confirmPassword) {
                    registerMessage.className = 'alert-message alert alert-danger';
                    registerMessage.textContent = 'Passwords do not match.';
                    registerMessage.style.display = 'block';
                    document.getElementById('confirmPassword').setCustomValidity('Passwords do not match');
                    return;
                } else {
                    document.getElementById('confirmPassword').setCustomValidity(''); // Clear custom validity
                }

                const formData = {
                    fullName: document.getElementById('fullName').value,
                    username: document.getElementById('username').value,
                    email: document.getElementById('email').value,
                    password: password,
                    userType: document.getElementById('userType').value // Added userType
                };

                registerMessage.className = 'alert-message alert alert-info';
                registerMessage.textContent = 'Attempting to register...';
                registerMessage.style.display = 'block';

                try {
                    const response = await fetch('register_process.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                        },
                        body: JSON.stringify(formData),
                    });

                    const data = await response.json();

                    if (data.success) {
                        registerMessage.className = 'alert-message alert alert-success';
                        registerMessage.textContent = data.message || 'Registration successful! You can now log in.';
                        adminRegisterForm.reset();
                        setTimeout(() => {
                            window.location.href = 'admin_login.php';
                        }, 2000);
                    } else {
                        registerMessage.className = 'alert-message alert alert-danger';
                        registerMessage.textContent = data.message || 'Registration failed. Please try again.';
                    }
                } catch (error) {
                    console.error('Error:', error);
                    registerMessage.className = 'alert-message alert alert-danger';
                    registerMessage.textContent = 'An error occurred during registration. Please try again.';
                } finally {
                    registerMessage.style.display = 'block';
                }
            });
        });
    </script>
<?php include_once 'footer.php'; ?>
