<?php
// Get Floor Details
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

require_once 'config.php';

$id = $_GET['id'] ?? 0;
if (!$id) {
    echo json_encode(['success' => false, 'message' => 'Invalid floor ID']);
    exit;
}

try {
    $stmt = $pdo->prepare("SELECT * FROM floors WHERE floor_id = ?");
    $stmt->execute([$id]);
    $floor = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($floor) {
        echo json_encode(['success' => true, 'floor' => $floor]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Floor not found']);
    }
} catch (PDOException $e) {
    error_log("Get floor error: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'Database error']);
}
