<?php
// get_hostel_details.php - Fetches details for a single hostel by ID

require_once 'config.php'; // Include database configuration
header('Content-Type: application/json'); // Set header to return JSON response

if (isset($_GET['id']) && !empty($_GET['id'])) {
    $hostelId = filter_var($_GET['id'], FILTER_SANITIZE_NUMBER_INT);

    //  FIXED: Corrected column name with alias
    $sql = "SELECT hostel_id, name, contact_person, contact_number, email, address, city, state, pincode, status 
            FROM hostels 
            WHERE hostel_id = :hostel_id";

    try {
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':hostel_id', $hostelId, PDO::PARAM_INT);
        $stmt->execute();
        $hostel = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($hostel) {
            echo json_encode(['success' => true, 'hostel' => $hostel]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Hostel not found.']);
        }
    } catch (PDOException $e) {
        error_log("Database error fetching hostel details: " . $e->getMessage());
        echo json_encode(['success' => false, 'message' => 'A database error occurred while fetching details.']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'No hostel ID provided.']);
}
