<?php
// student_registration_step6.php
session_start();

// Auth check
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php');
    exit;
}

$pageTitle = 'Floors Registration - Step 6';
require_once 'config.php';
include_once '_header.php';
include_once '_sidebar.php';
?>
<main class="container-fluid" id="appContent">
    <h5 class="mb-4">Student Registration - Step 6</h5>

    <div class="form-header">
        <h2>School Hostel Registration</h2>
        <p class="text-muted">Upload Documents</p>
    </div>

    <!-- Step Indicator -->
    <div class="step-indicator mb-4">
        <div class="step"><div class="step-circle">1</div><div class="step-label">Student Info</div></div>
        <div class="step"><div class="step-circle">2</div><div class="step-label">Parent Details</div></div>
        <div class="step"><div class="step-circle">3</div><div class="step-label">Address</div></div>
        <div class="step"><div class="step-circle">4</div><div class="step-label">Emergency Contact</div></div>
        <div class="step"><div class="step-circle">5</div><div class="step-label">Hostel Preferences</div></div>
        <div class="step active" id="step6">
            <div class="step-circle">6</div>
            <div class="step-label">Documents</div>
        </div>
    </div>

    <!-- Document Upload Form -->
    <form id="documentUploadForm" enctype="multipart/form-data">
        <input type="hidden" name="uniqueId" id="uniqueId">

        <div class="row g-3 mb-4">
            <div class="col-md-6">
                <label for="studentPhoto" class="form-label">Student Photo <span class="text-danger">*</span></label>
                <input type="file" class="form-control" id="studentPhoto" name="studentPhoto" accept="image/*" required>
            </div>
            <div class="col-md-6">
                <label for="aadharCard" class="form-label">Aadhar Card (PDF/JPG/PNG) <span class="text-danger">*</span></label>
                <input type="file" class="form-control" id="aadharCard" name="aadharCard" accept=".pdf,image/*" required>
            </div>
        </div>

        <button type="submit" class="btn btn-primary">Upload & Finish</button>
    </form>

    <div id="result" class="mt-3"></div>
</main>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function() {
    const urlParams = new URLSearchParams(window.location.search);
    const regId = urlParams.get('reg');
    if (regId) {
        $('#uniqueId').val(regId);
    }

    $("#documentUploadForm").on("submit", function(e) {
        e.preventDefault();
        var formData = new FormData(this);

        $.ajax({
            url: "student_registration_step6_action.php",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            dataType: "json",
            success: function(data) {
                if (data.status === "success") {
                    $("#result").html('<div class="alert alert-success">'+data.message+'</div>');
                    // You can redirect to a success page or dashboard here
                } else {
                    $("#result").html('<div class="alert alert-danger">'+data.message+'</div>');
                }
            },
            error: function() {
                $("#result").html('<div class="alert alert-danger">An unexpected error occurred</div>');
            }
        });
    });
});
</script>
<?php include_once 'footer.php'; ?>
