<?php
session_start();
require_once 'db.php';

// Auth check
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php');
    exit;
}

if (!isset($_GET['reg']) || !isset($_GET['status'])) {
    die("Invalid request");
}

$regNo = $_GET['reg'];
$status = $_GET['status'] === 'active' ? 'active' : 'inactive';

$stmt = $conn->prepare("UPDATE students SET status = ? WHERE unique_reg_number = ?");
$stmt->bind_param("ss", $status, $regNo);
if ($stmt->execute()) {
    header("Location: view_student_profile.php?reg=" . urlencode($regNo));
} else {
    die("Error updating status");
}
$stmt->close();
$conn->close();
