<?php
// Update Floor
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

require_once 'config.php';

$data = json_decode(file_get_contents("php://input"), true);

if (!$data || empty($data['floor_id']) || empty($data['hostelId']) || empty($data['floorNumber'])) {
    echo json_encode(['success' => false, 'message' => 'Invalid input']);
    exit;
}

try {
    $stmt = $pdo->prepare("UPDATE floors 
                           SET hostel_id = ?, floor_number = ?, description = ?, total_rooms = ?
                           WHERE floor_id = ?");
    $stmt->execute([
        $data['hostelId'],
        $data['floorNumber'],
        $data['description'] ?? '',
        $data['totalRooms'] ?? 0,
        $data['floor_id']
    ]);

    echo json_encode(['success' => true, 'message' => 'Floor updated successfully']);
} catch (PDOException $e) {
    error_log("Update floor error: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'Database error']);
}
