<?php
session_start();
require_once 'db.php';

// Auth check
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php');
    exit;
}

$pageTitle = "Floors";
include_once '_header.php';
include_once '_sidebar.php';
?>
<main class="container-fluid" id="appContent">
    <h5 class="mb-4">View Floors</h5>

    <div class="card shadow-sm">
        <div class="card-body">
            <div class="table-responsive">
                <table id="floorsTable" class="table table-striped table-bordered display nowrap" style="width:100%">
                    <thead class="table-dark">
                        <tr>
                            <th>Floor ID</th>
                            <th>Hostel Name</th>
                            <th>Floor Number</th>
                            <th>Description</th>
                            <th>Total Rooms</th>
                            <th>Created At</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        // Fetch floors with hostel name
                        $sql = "SELECT f.floor_id, h.name AS hostel_name, f.floor_number, f.description, f.total_rooms, f.created_at 
                                FROM floors f
                                JOIN hostels h ON f.hostel_id = h.hostel_id
                                ORDER BY f.created_at DESC";
                        $result = $conn->query($sql);

                        if ($result && $result->num_rows > 0) {
                            while ($row = $result->fetch_assoc()) {
                                echo "<tr>
                                    <td>{$row['floor_id']}</td>
                                    <td>" . htmlspecialchars($row['hostel_name']) . "</td>
                                    <td>" . htmlspecialchars($row['floor_number']) . "</td>
                                    <td>" . htmlspecialchars($row['description']) . "</td>
                                    <td>" . htmlspecialchars($row['total_rooms']) . "</td>
                                    <td>" . htmlspecialchars($row['created_at']) . "</td>
                                    <td>
                                        <a href='edit_floor.php?id={$row['floor_id']}' class='btn btn-sm btn-warning'>Edit</a>
                                        <a href='delete_floor.php?id={$row['floor_id']}' class='btn btn-sm btn-danger' onclick=\"return confirm('Are you sure you want to delete this floor?');\">Delete</a>
                                    </td>
                                </tr>";
                            }
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<!-- DataTables & Buttons CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.dataTables.min.css">

<!-- jQuery & DataTables JS -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>

<script>
$(document).ready(function() {
    $('#floorsTable').DataTable({
        responsive: true,
        scrollX: true,
        dom: 'Bfrtip',
        buttons: [
            { extend: 'excelHtml5', title: 'Floors_List' },
            { extend: 'csvHtml5', title: 'Floors_List' }
        ]
    });
});
</script>

<?php include_once 'footer.php'; ?>
