<?php
// view_gate_enquiries.php
session_start();
require_once "config.php";
// Auth check
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: admin_login.php");
    exit;
}
$pageTitle = "GatePass";
include_once "_header.php";
include_once "_sidebar.php";

// Fetch enquiries
try {
    $sql = "SELECT * FROM gate_enquiries ORDER BY created_at DESC";
    $stmt = $pdo->prepare($sql);
    $stmt->execute();
    $enquiries = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    $errorMessage = "Error fetching enquiries: " . $e->getMessage();
}
?>
<main class="container-fluid" id="appContent">
    <h2 class="mb-4">Gate Enquiries</h2>
    <?php if (isset($errorMessage)): ?>
        <div class="alert alert-danger"><?php echo htmlspecialchars($errorMessage); ?></div>
    <?php endif; ?>
    <div class="card shadow-sm">
        <div class="card-body table-responsive">
            <table id="gateEnquiriesTable" class="table table-bordered table-striped align-middle">
                <thead class="table-dark">
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Mobile</th>
                        <th>Purpose</th>
                        <th>Photo</th>
                        <th>Document</th>
                        <th>OTP Verified</th>
                        <th>Created At</th>
                        <?php if (!empty($_SESSION['is_super_admin']) && $_SESSION['is_super_admin']): ?>
                            <th>Action</th>
                        <?php endif; ?>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($enquiries as $enquiry): ?>
                    <tr>
                        <td><?php echo $enquiry['enquiry_id']; ?></td>
                        <td><?php echo htmlspecialchars($enquiry['visitor_name']); ?></td>
                        <td><?php echo htmlspecialchars($enquiry['mobile']); ?></td>
                        <td><?php echo htmlspecialchars($enquiry['purpose']); ?></td>
                        <td>
                            <?php if ($enquiry['photo_path']): ?>
                                <a href="<?php echo $enquiry['photo_path']; ?>" target="_blank">
                                    <img src="<?php echo $enquiry['photo_path']; ?>" alt="photo" width="50" height="50">
                                </a>
                            <?php else: ?>
                                <span class="text-muted">N/A</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($enquiry['document_path']): ?>
                                <a href="<?php echo $enquiry['document_path']; ?>" target="_blank" class="btn btn-sm btn-info">
                                    View Doc
                                </a>
                            <?php else: ?>
                                <span class="text-muted">N/A</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($enquiry['otp_verified'] == 1): ?>
                                <span class="badge bg-success">Yes</span>
                            <?php else: ?>
                                <span class="badge bg-danger">No</span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo $enquiry['created_at']; ?></td>
                        <?php if (!empty($_SESSION['is_super_admin']) && $_SESSION['is_super_admin']): ?>
                        <td>
                            <button class="btn btn-sm btn-danger delete-btn" data-id="<?php echo $enquiry['enquiry_id'] ?>">
                                <i class="fas fa-trash"></i> Delete
                            </button>
                        </td>
                        <?php endif; ?>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</main>
<!-- DataTables -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.dataTables.min.css">
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script>
$(document).ready(function() {
    $('#gateEnquiriesTable').DataTable({
        responsive: true,
        dom: 'Bfrtip',
        buttons: [
            { extend: 'excelHtml5', className: 'btn btn-success btn-sm', title: 'Gate Enquiries' },
            { extend: 'print', className: 'btn btn-info btn-sm', title: 'Gate Enquiries' }
        ]
    });
    // Delete enquiry
    $(document).on('click', '.delete-btn', function() {
        if(confirm("Are you sure you want to delete this enquiry?")) {
            let id = $(this).data('id');
            $.post('delete_gate_enquiry.php', { id: id }, function(resp) {
                location.reload();
            });
        }
    });
});
</script>
<?php include_once "footer.php"; ?>
